import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:wordpress_app/blocs/tab_scroll_controller.dart';
import 'package:wordpress_app/config/custom_ad_config.dart';
import 'package:wordpress_app/constants/constant.dart';
import 'package:wordpress_app/models/app_config_model.dart';
import 'package:wordpress_app/services/app_service.dart';
import 'package:wordpress_app/widgets/custom_ad.dart';
import 'package:wordpress_app/widgets/featured.dart';
import 'package:wordpress_app/widgets/popular_articles.dart';
import '../blocs/config_bloc.dart';
import '../blocs/featured_bloc.dart';
import '../blocs/latest_articles_bloc.dart';
import '../blocs/popular_articles_bloc.dart';
import '../blocs/theme_bloc.dart';
import '../widgets/lattest_articles.dart';
import '../widgets/native_ad_widget.dart';

class Tab0 extends ConsumerStatefulWidget {
  const Tab0({super.key, required this.sc});
  final ScrollController sc;

  @override
  ConsumerState<Tab0> createState() => _Tab0State();
}

class _Tab0State extends ConsumerState<Tab0> {

  
  Future _onRefresh(ConfigModel configs) async {
    if(configs.featuredPostEnabled){
      ref.read(featuredBlocProvider).updatePageIndex(0);
      ref.read(featuredBlocProvider).fetchData();
    }
    if(configs.popularPostEnabled){
      ref.read(popularArticlesBlocProvider).fetchData();
    }
    ref.read(latestArticlesBlocProvider).onReload(configs.blockedCategories);
  }

  @override
  void initState() {
    super.initState();
    widget.sc.addListener(_scrollListener);
  }

  void _scrollListener() {
    bool isEnd = TabScrollController().isEnd(widget.sc);
    debugPrint('isEnd: $isEnd');
    if (mounted) {
      final lb = ref.read(latestArticlesBlocProvider);
      if (isEnd && lb.articles.isNotEmpty) {
        lb.pageIncreament();
        lb.setLoading(true);
        lb.fetchData(ref.read(configBlocProvider).configs!.blockedCategories).then((value) {
          lb.setLoading(false);
        });
      }
    }
  }

  @override
  Widget build(BuildContext context) {
    final configs = ref.read(configBlocProvider).configs!;
    return RefreshIndicator(
      backgroundColor: Theme.of(context).primaryColor,
      color: Colors.white,
      onRefresh: () async => _onRefresh(configs),
      child: CustomScrollView(
        key: const PageStorageKey('key0'),
        physics: const AlwaysScrollableScrollPhysics(),
        slivers: [
          //Featured Posts
          if (configs.featuredPostEnabled)
            const SliverToBoxAdapter(
              child: Featured(),
            ),

          //Popular Posts
          if (configs.popularPostEnabled)
            const SliverToBoxAdapter(
              child: PopularArticles(),
            ),

          //Native ads
          if (AppService.nativeAdVisible(Constants.adPlacements[0], configs))
            SliverToBoxAdapter(
              child: NativeAdWidget(isDarkMode: ref.read(themeBlocProvider).darkTheme ?? false, isSmallSize: false),
            ),

          //custom Ads
          if (AppService.customAdVisible(Constants.adPlacements[0], configs))
            SliverToBoxAdapter(
              child: Container(
                padding: const EdgeInsets.only(top: 20, bottom: 20),
                height: CustomAdConfig.defaultPosterHeight,
                child: CustomAdWidget(assetUrl: configs.customAdAssetUrl, targetUrl: configs.customAdDestinationUrl),
              ),
            ),
          
          //Latest Posts
          const LattestArticles(),
        ],
      ),
    );
  }
}
